//%attributes = {}
// Method: _err_ CALL_GENERIC 
// 18.08.11, 02:17:08 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

// ----------------------------------------------------
// User name (OS):
// Date and time:
// ----------------------------------------------------
// Method: Generic_Error_Proc
// Description
// Specify with ON ERR CALL("Generic_Error_Proc") to
// capture and report 4D errors. This method can handle
// 4D Engine Errors, SQL Engine Errors and Trigger Errors
// It also collects some information about the execution context
// The diagnostic information included is intended for developers, not end users.
//
// Parameters
// ----------------------------------------------------
// 4D does not pass in params to this function instead it sets
// System Variables Error, Error method, and Error Line (the latter two only in v12 http://kb.4d.com/search/assetid=76150)

C_LONGINT:C283($errCode; $i)
C_TEXT:C284($errText; $vt_TableName; $errODBC)
C_LONGINT:C283($errSQLServer; vl_Statement)

C_LONGINT:C283($Error)
C_TEXT:C284($Message)

C_POINTER:C301($vp_ParentTable)
C_LONGINT:C283($vl_RecordNum)

SQL GET LAST ERROR:C825($errCode; $errText; $errODBC; $errSQLServer)

ARRAY INTEGER:C220($codesArray; 0)
_O_ARRAY STRING:C218(50; $internalCompArray; 0)
_O_ARRAY STRING:C218(255; $textArray; 0)

GET LAST ERROR STACK:C1015($codesArray; $internalCompArray; $textArray)

// general 4D error stack only if there is an error
If (Error#0)
	$Message:=$Message+"General Message(Error Stack):"+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"Error: "+String:C10(Error)+Char:C90(Carriage return:K15:38)
	// Available in 4Dv12 is Error Line and Error method process variables
	For ($i; 1; Size of array:C274($codesArray))
		// Do something with the element
		$Message:=$Message+String:C10($codesArray{$i})+Char:C90(Tab key:K12:28)+$internalCompArray{$i}+Char:C90(Carriage return:K15:38)+$textArray{$i}+Char:C90(Carriage return:K15:38)+Char:C90(Carriage return:K15:38)
	End for 
	$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)
End if 

// return information if it is a trigger based error too
C_LONGINT:C283($tLevel)
$tLevel:=Trigger level:C398
If ($tLevel#0)
	C_LONGINT:C283($dbEvent; $tableNum; $recordNum)
	TRIGGER PROPERTIES:C399($tLevel; $dbEvent; $tableNum; $recordNum)
	
	$Message:=$Message+"Trigger Message: "+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"Table Name - Record Number: "+Table name:C256($tableNum)+" - "+String:C10($recordNum)+Char:C90(Carriage return:K15:38)
	// Choose is 0 based, Database event is 1 based. so pad the results with a blank string
	$Message:=$Message+"Event: "+Choose:C955($dbEvent; ""; "Saving New"; "Saving Existing"; "Deleting")+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)
	$Message:=$Message+Char:C90(Carriage return:K15:38)
	
End if 

// 4D SQL error stack (thrown by new SQL engine)
If ($errCode#0)
	$Message:=$Message+"SQL MESSAGE: "+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"Data Source: "+Get current data source:C990+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"Error Code: "+String:C10($errCode)+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"Error Text: "+$errText+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"Error ODBC: "+$errODBC+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"Error SQL Server: "+String:C10($errSQLServer)+Char:C90(Carriage return:K15:38)
	$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)
	$Message:=$Message+Char:C90(Carriage return:K15:38)
End if 

// Finally lets collect some user information and timestamps
$vp_ParentTable:=Current form table:C627
If (Not:C34(Is nil pointer:C315($vp_ParentTable)))
	$vl_RecordNum:=Record number:C243($vp_ParentTable->)
	$vt_TableName:=Table name:C256($vp_ParentTable)
Else 
	$vl_RecordNum:=-1
	$vt_TableName:="Nil"
End if 

$Message:=$Message+Char:C90(Carriage return:K15:38)+"Client Information: "+Char:C90(Carriage return:K15:38)
$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)
$Message:=$Message+"Current User: "+Current user:C182+Char:C90(Carriage return:K15:38)
$Message:=$Message+"Current Machine: "+Current machine:C483+Char:C90(Carriage return:K15:38)
$Message:=$Message+"Current form table: "+$vt_TableName+Char:C90(Carriage return:K15:38)
$Message:=$Message+"Current record num: "+String:C10($vl_RecordNum)+Char:C90(Carriage return:K15:38)
// only in 4D V12
// $Message:=$Message+"Error method: "+Error method+Char(Carriage return )
// $Message:=$Message+"Error line: "+String(Error Line)+Char(Carriage return )
$Message:=$Message+"Date:  "+String:C10(Current date:C33(*); Internal date long:K1:5)+Char:C90(Carriage return:K15:38)
$Message:=$Message+"Time:  "+String:C10(Current time:C178(*); HH MM AM PM:K7:5)+Char:C90(Carriage return:K15:38)
$Message:=$Message+"_____________________________________"+Char:C90(Carriage return:K15:38)

// alert this to the user. or store it in the database in the above for loops.
_info_ ALERT($Message)